package ru.yandex.mail.cerberus.core.mapper;

import ru.yandex.mail.cerberus.GroupKey;
import ru.yandex.mail.cerberus.RoleId;
import ru.yandex.mail.cerberus.Uid;
import ru.yandex.mail.cerberus.client.dto.Grant;
import ru.yandex.mail.cerberus.dao.grant.GrantEntity;

import javax.inject.Singleton;

import java.util.Optional;

import static ru.yandex.mail.cerberus.dao.DaoConstants.nextval;

@Singleton
public class GrantMapper {
    public GrantEntity mapToEntity(Uid uid, Grant grant) {
        return new GrantEntity(nextval(), Optional.of(uid), Optional.empty(), Optional.empty(), Optional.empty(),
            grant.getResourceType(), grant.getResourceId(), grant.getActions());
    }

    public GrantEntity mapToEntity(RoleId roleId, Grant grant) {
        return new GrantEntity(nextval(), Optional.empty(), Optional.of(roleId), Optional.empty(), Optional.empty(),
            grant.getResourceType(), grant.getResourceId(), grant.getActions());
    }

    public GrantEntity mapToEntity(GroupKey groupKey, Grant grant) {
        return new GrantEntity(nextval(), Optional.empty(), Optional.empty(), Optional.of(groupKey.getId()), Optional.of(groupKey.getType()),
            grant.getResourceType(), grant.getResourceId(), grant.getActions());
    }

    public Grant mapToGrant(GrantEntity entity) {
        return new Grant(entity.getActions(), entity.getResourceType(), entity.getResourceId());
    }
}
