package ru.yandex.mail.cerberus.core.mapper;

import lombok.AllArgsConstructor;
import lombok.val;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.micronaut.common.JsonMapper;
import ru.yandex.mail.cerberus.client.dto.GroupData;
import ru.yandex.mail.cerberus.client.dto.Group;
import ru.yandex.mail.cerberus.dao.group.GroupEntity;

import javax.inject.Inject;
import javax.inject.Singleton;

import static ru.yandex.mail.cerberus.dao.DaoConstants.nextval;

@Singleton
@AllArgsConstructor(onConstructor_= @Inject)
public class GroupMapper {
    private final JsonMapper jsonMapper;

    public <T> GroupEntity mapToEntity(Group<T> group) {
        return mapToEntity(group.getId(), group.getData());
    }

    public <T> GroupEntity mapToEntity(GroupData<T> data) {
        return mapToEntity(nextval(), data);
    }

    public <T> GroupEntity mapToEntity(GroupId id, GroupData<T> data) {
        val info = data.getInfo().map(jsonMapper::toJson);
        return new GroupEntity(id, data.getType(), data.getName(), data.isActive(), info);
    }

    public <T> Group<T> mapToGroup(GroupEntity entity, Class<T> infoType) {
        final var info = entity.getInfo().map(json -> jsonMapper.fromJson(json, infoType));
        return new Group<>(entity.getId(), entity.getType(), entity.getName(), entity.isActive(), info);
    }
}
