package ru.yandex.mail.cerberus.core.mapper;

import lombok.AllArgsConstructor;
import lombok.val;
import ru.yandex.mail.micronaut.common.JsonMapper;
import ru.yandex.mail.cerberus.LocationId;
import ru.yandex.mail.cerberus.client.dto.Location;
import ru.yandex.mail.cerberus.client.dto.LocationData;
import ru.yandex.mail.cerberus.dao.location.LocationEntity;

import javax.inject.Inject;
import javax.inject.Singleton;

import static ru.yandex.mail.cerberus.dao.DaoConstants.nextval;

@Singleton
@AllArgsConstructor(onConstructor_= @Inject)
public class LocationMapper {
    private final JsonMapper jsonMapper;

    public <T> LocationEntity mapToEntity(Location<T> location) {
        return mapToEntity(location.getId(), location.getData());
    }

    public <T> LocationEntity mapToEntity(LocationData<T> data) {
        return mapToEntity(nextval(), data);
    }

    public <T> LocationEntity mapToEntity(LocationId id, LocationData<T> data) {
        val info = data.getInfo().map(jsonMapper::toJson);
        return new LocationEntity(id, data.getType(), data.getName(), info);
    }

    public <T> Location<T> mapToLocation(LocationEntity entity, Class<T> infoType) {
        final var info = entity.getInfo().map(value -> jsonMapper.fromJson(value, infoType));
        return new Location<>(entity.getId(), entity.getType(), entity.getName(), info);
    }
}
