package ru.yandex.mail.cerberus.core.mapper;

import lombok.AllArgsConstructor;
import lombok.val;
import ru.yandex.mail.micronaut.common.JsonMapper;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.client.dto.Resource;
import ru.yandex.mail.cerberus.client.dto.ResourceData;
import ru.yandex.mail.cerberus.dao.resource.ResourceEntity;

import javax.inject.Inject;
import javax.inject.Singleton;
import java.util.Optional;

import static ru.yandex.mail.cerberus.dao.DaoConstants.nextval;

@Singleton
@AllArgsConstructor(onConstructor_= @Inject)
public class ResourceMapper {
    private final JsonMapper jsonMapper;

    public <T> Resource<T> mapToResource(ResourceEntity entity, Class<T> infoType) {
        final var info = entity.getInfo().map(json -> jsonMapper.fromJson(json, infoType));
        final var data = new ResourceData<>(entity.getType(), entity.getName(), Optional.ofNullable(entity.getLocation()),
            entity.isActive(), info);
        return new Resource<>(entity.getId(), data);
    }

    public <T> ResourceEntity mapToEntity(ResourceId id, ResourceData<T> data) {
        val info = data.getInfo().map(jsonMapper::toJson);
        return new ResourceEntity(id, data.getType(), data.getLocation().orElse(null), data.getName(), data.isActive(), info);
    }

    public <T> ResourceEntity mapToEntity(Resource<T> resource) {
        return mapToEntity(resource.getId(), resource.getData());
    }

    public <T> ResourceEntity mapToEntity(ResourceData<T> data) {
        return mapToEntity(nextval(), data);
    }
}
