package ru.yandex.mail.cerberus.core.mapper;

import ru.yandex.mail.cerberus.client.dto.Role;
import ru.yandex.mail.cerberus.client.dto.RoleData;
import ru.yandex.mail.cerberus.dao.role.RoleEntity;

import javax.inject.Singleton;

import static ru.yandex.mail.cerberus.dao.DaoConstants.nextval;

@Singleton
public class RoleMapper {
    public RoleEntity mapToEntity(RoleData data) {
        return new RoleEntity(nextval(), data.getName(), data.isActive(), data.getDescription());
    }

    public RoleEntity mapToEntity(Role role) {
        return new RoleEntity(role.getId(), role.getName(), role.isActive(), role.getDescription());
    }

    public Role mapToRole(RoleEntity entity) {
        return new Role(entity.getId(), entity.getName(), entity.getDescription(), entity.isActive());
    }
}
