package ru.yandex.mail.cerberus.core.mapper;

import lombok.AllArgsConstructor;
import ru.yandex.mail.micronaut.common.JsonMapper;
import ru.yandex.mail.cerberus.client.dto.User;
import ru.yandex.mail.cerberus.dao.user.UserEntity;

import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@AllArgsConstructor(onConstructor_= @Inject)
public class UserMapper {
    private final JsonMapper jsonMapper;

    public <T> UserEntity mapToEntity(User<T> user) {
        final var info = user.getInfo().map(jsonMapper::toJson);
        return new UserEntity(user.getUid(), user.getType(), user.getLogin(), info);
    }

    public <T> User<T> mapToUser(UserEntity entity, Class<T> infoType) {
        final var info = entity.getInfo().map(json -> jsonMapper.fromJson(json, infoType));
        return new User<>(entity.getUid(), entity.getType(), entity.getLogin(), info);
    }
}
