package ru.yandex.mail.cerberus.core.resource;

import io.micronaut.context.annotation.DefaultImplementation;
import ru.yandex.mail.cerberus.core.CollisionStrategy;
import ru.yandex.mail.cerberus.core.DeletionMode;
import ru.yandex.mail.micronaut.common.Page;
import ru.yandex.mail.micronaut.common.Pageable;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceKey;
import ru.yandex.mail.cerberus.ResourceTypeName;
import ru.yandex.mail.cerberus.client.dto.Resource;
import ru.yandex.mail.cerberus.client.dto.ResourceData;
import ru.yandex.mail.cerberus.client.dto.ResourceType;
import ru.yandex.mail.cerberus.ReadTarget;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

@DefaultImplementation(DefaultResourceManager.class)
public interface ResourceManager {
    default ReadTarget defaultReadTarget() {
        return ReadTarget.SLAVE;
    }

    CompletableFuture<ResourceType> createType(ResourceType data);

    CompletableFuture<ResourceType> getByNameOrCreateType(ResourceType data);

    CompletableFuture<List<ResourceType>> getTypes(Set<ResourceTypeName> names, ReadTarget readTarget);

    default CompletableFuture<List<ResourceType>> getTypes(Set<ResourceTypeName> names) {
        return getTypes(names, defaultReadTarget());
    }

    CompletableFuture<Set<String>> getPossibleActions(ResourceTypeName type, ReadTarget readTarget);

    default CompletableFuture<Set<String>> getPossibleActions(ResourceTypeName type) {
        return getPossibleActions(type, defaultReadTarget());
    }

    <T> CompletableFuture<Resource<T>> createResource(ResourceData<T> resourceData);

    <T> CompletableFuture<List<Resource<T>>> createResources(List<ResourceData<T>> resourcesData, Class<T> infoType);

    <T> CompletableFuture<List<Resource<T>>> insertResources(CollisionStrategy collisionStrategy, List<Resource<T>> resources);

    <T> CompletableFuture<Page<ResourceKey, Resource<T>>> resources(Pageable<ResourceKey> pageable, Class<T> infoType,
                                                                    ReadTarget readTarget);

    default <T> CompletableFuture<Page<ResourceKey, Resource<T>>> resources(Pageable<ResourceKey> pageable, Class<T> infoType) {
        return resources(pageable, infoType, defaultReadTarget());
    }

    <T> CompletableFuture<Page<ResourceId, Resource<T>>> resources(ResourceTypeName type, Pageable<ResourceId> pageable,
                                                                   Class<T> infoType, ReadTarget readTarget);

    default <T> CompletableFuture<Page<ResourceId, Resource<T>>> resources(ResourceTypeName type, Pageable<ResourceId> pageable,
                                                                           Class<T> infoType) {
        return resources(type, pageable, infoType, defaultReadTarget());
    }

    <T> CompletableFuture<List<Resource<T>>> findResources(ResourceTypeName type, Set<ResourceId> ids, Class<T> infoType,
                                                           ReadTarget readTarget);

    default <T> CompletableFuture<List<Resource<T>>> findResources(ResourceTypeName type, Set<ResourceId> ids, Class<T> infoType) {
        return findResources(type, ids, infoType, defaultReadTarget());
    }

    <T> CompletableFuture<Void> updateResource(Resource<T> resource);

    <T> CompletableFuture<Void> updateResources(Collection<Resource<T>> resources);

    CompletableFuture<Void> deleteResource(ResourceKey key, DeletionMode mode);

    default <T> CompletableFuture<Void> deleteResource(Resource<T> resource, DeletionMode mode) {
        return deleteResource(resource.extractKey(), mode);
    }

    CompletableFuture<Void> deleteResources(ResourceTypeName type, Set<ResourceId> ids, DeletionMode mode);
}
