package ru.yandex.mail.cerberus.core.role;

import io.micronaut.context.annotation.DefaultImplementation;
import ru.yandex.mail.cerberus.GroupKey;
import ru.yandex.mail.cerberus.core.DeletionMode;
import ru.yandex.mail.micronaut.common.Page;
import ru.yandex.mail.micronaut.common.Pageable;
import ru.yandex.mail.cerberus.RoleId;
import ru.yandex.mail.cerberus.Uid;
import ru.yandex.mail.cerberus.client.dto.Role;
import ru.yandex.mail.cerberus.client.dto.RoleData;
import ru.yandex.mail.cerberus.ReadTarget;

import java.util.concurrent.CompletableFuture;

@DefaultImplementation(DefaultRoleManager.class)
public interface RoleManager {
    default ReadTarget defaultReadTarget() {
        return ReadTarget.SLAVE;
    }

    CompletableFuture<Role> create(RoleData data);

    CompletableFuture<Void> update(Role role);

    CompletableFuture<Void> delete(RoleId id, DeletionMode mode);

    CompletableFuture<Void> delete(String name, DeletionMode mode);

    CompletableFuture<Page<RoleId, Role>> roles(Pageable<RoleId> pageable, ReadTarget readTarget);

    default CompletableFuture<Page<RoleId, Role>> roles(Pageable<RoleId> pageable) {
        return roles(pageable, defaultReadTarget());
    }

    CompletableFuture<Boolean> exists(RoleId id, ReadTarget readTarget);

    default CompletableFuture<Boolean> exists(RoleId id) {
        return exists(id, defaultReadTarget());
    }

    CompletableFuture<Void> attachRoleToGroup(GroupKey groupKey, RoleId roleId);

    CompletableFuture<Void> attachRoleToUser(Uid uid, RoleId roleId);

    CompletableFuture<Void> detachRoleFromGroup(GroupKey groupKey, RoleId roleId);

    CompletableFuture<Void> detachRoleFromUser(Uid uid, RoleId roleId);
}
