package ru.yandex.mail.cerberus.dao;

import io.micronaut.context.annotation.DefaultImplementation;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;

import java.util.Optional;

@DefaultImplementation(DefaultDataAccessExceptionMapper.class)
public interface DataAccessExceptionMapper {
    default Optional<Throwable> map(DataAccessException e) {
        if (e instanceof DataIntegrityViolationException) {
            return map((DataIntegrityViolationException) e);
        } else {
            return Optional.empty();
        }
    }

    Optional<Throwable> map(DataIntegrityViolationException e);
}
