package ru.yandex.mail.cerberus.dao;

import io.micronaut.configuration.jdbc.hikari.DatasourceConfiguration;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import lombok.val;
import ru.yandex.mail.micronaut.common.thread_factory.NamedThreadFactory;

import javax.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Factory
public class DataSourceExecutorFactory {
    @Singleton
    @EachBean(DatasourceConfiguration.class)
    public ExecutorService dataSourceExecutor(DatasourceConfiguration configuration, @Parameter String name) {
        configuration.validate();
        val maxConnections = configuration.getMaximumPoolSize();
        val threadFactory = new NamedThreadFactory("db-" + name + "-pool");
        return Executors.newFixedThreadPool(maxConnections, threadFactory);
    }
}
