package ru.yandex.mail.cerberus.dao;

import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.jdbc.BasicJdbcConfiguration;
import io.micronaut.scheduling.TaskExecutors;
import lombok.Data;

import java.time.Duration;

@Data
@EachProperty(value = BasicJdbcConfiguration.PREFIX, primary = "default")
public class ExtendedDatasourceConfiguration {
    private final String name;
    private boolean readOnly = false;
    private Duration defaultQueryTimeout;
    private String forwardingExecutor = TaskExecutors.IO;

    public ExtendedDatasourceConfiguration(@Parameter String name) {
        this.name = name;
    }
}
