package ru.yandex.mail.cerberus.dao;

import ru.yandex.mail.cerberus.ReadTarget;
import ru.yandex.mail.cerberus.asyncdb.Repository;

import java.util.Optional;

public class RepositoryGroup<RoRepo extends Repository, Repo extends RoRepo> {
    private final Repo repository;
    private final RoRepo roRepository;

    public RepositoryGroup(Repo repository, Optional<RoRepo> roRepository) {
        this.repository = repository;
        this.roRepository = roRepository.orElse(repository);
    }

    public RoRepo getReading(ReadTarget readTarget) {
        return readTarget == ReadTarget.SLAVE ? roRepository : repository;
    }

    public RoRepo getReading() {
        return roRepository;
    }

    public Repo getWriting() {
        return repository;
    }
}
