package ru.yandex.mail.cerberus.dao.change_log;

import lombok.Value;
import ru.yandex.mail.cerberus.ChangeId;
import ru.yandex.mail.cerberus.asyncdb.annotations.Id;
import ru.yandex.mail.cerberus.asyncdb.annotations.JsonB;
import ru.yandex.mail.cerberus.asyncdb.annotations.Serial;

import java.time.OffsetDateTime;
import java.util.OptionalLong;

@Value
public class ChangeLogEntity {
    @Id @Serial ChangeId cid;
    ChangeAction action;
    ChangeSubjectType subjectType;
    @JsonB String subject;
    OffsetDateTime changeTime;
    OptionalLong actorUid;
    String actorServiceName;
    String requestId;
    @JsonB String change;
}
