package ru.yandex.mail.cerberus.dao.grant;

import lombok.Value;
import ru.yandex.mail.cerberus.GrantId;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.cerberus.GroupKey;
import ru.yandex.mail.cerberus.GroupType;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceTypeName;
import ru.yandex.mail.cerberus.RoleId;
import ru.yandex.mail.cerberus.Uid;
import ru.yandex.mail.cerberus.asyncdb.annotations.Id;
import ru.yandex.mail.cerberus.asyncdb.annotations.Serial;

import java.util.Optional;
import java.util.Set;

@Value
public class GrantEntity {
    @Id @Serial GrantId id;
    Optional<Uid> uid;
    Optional<RoleId> roleId;
    Optional<GroupId> groupId;
    Optional<GroupType> groupType;
    ResourceTypeName resourceType;
    Optional<ResourceId> resourceId;
    Set<String> actions;

    public Optional<GroupKey> extractGroupKey() {
        return groupId.flatMap(id -> {
            return groupType.map(type -> new GroupKey(id, type));
        });
    }
}
