package ru.yandex.mail.cerberus.dao.grant;

import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceKey;
import ru.yandex.mail.cerberus.ResourceTypeName;

import java.util.Optional;

@Value
@AllArgsConstructor
public class ResourceIdEntity {
    public ResourceIdEntity(ResourceKey key) {
        this(key.getType(), Optional.of(key.getId()));
    }

    public ResourceIdEntity(ResourceTypeName type) {
        this(type, Optional.empty());
    }

    public ResourceIdEntity(ResourceActionsEntity entity) {
        this(entity.getResourceType(), entity.getResourceId());
    }

    ResourceTypeName resourceType;
    Optional<ResourceId> resourceId;
}
