package ru.yandex.mail.cerberus.dao.group;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.cerberus.GroupKey;
import ru.yandex.mail.cerberus.GroupType;
import ru.yandex.mail.cerberus.asyncdb.annotations.Id;
import ru.yandex.mail.cerberus.asyncdb.annotations.JsonB;
import ru.yandex.mail.cerberus.asyncdb.annotations.Serial;

import java.util.Optional;

@Value
@AllArgsConstructor
@Builder(toBuilder = true)
public class GroupEntity {
    @Id @Serial GroupId id;
    @Id GroupType type;
    String name;
    boolean active;
    @JsonB Optional<String> info;

    public GroupKey extractKey() {
        return new GroupKey(id, type);
    }
}
