package ru.yandex.mail.cerberus.dao.group;

import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.cerberus.GroupKey;
import ru.yandex.mail.cerberus.GroupType;
import ru.yandex.mail.cerberus.RoleId;
import ru.yandex.mail.cerberus.asyncdb.CrudRepository;
import ru.yandex.mail.cerberus.asyncdb.annotations.CompositeId;
import ru.yandex.mail.cerberus.asyncdb.annotations.ConfigureCrudRepository;

@CompositeId
@ConfigureCrudRepository(table = "cerberus.groups")
public interface GroupRepository extends RoGroupRepository, CrudRepository<GroupKey, GroupEntity> {
    @SqlUpdate("INSERT INTO cerberus.group_roles (group_id, group_type, role_id)\n"
             + "VALUES (:groupId, :type, :roleId)\n"
             + "ON CONFLICT DO NOTHING")
    void attachRole(GroupId groupId, GroupType type, RoleId roleId);

    @SqlUpdate("DELETE FROM cerberus.group_roles\n"
             + "WHERE group_id = :groupId AND group_type = :type AND role_id = :roleId")
    void detachRole(GroupId groupId, GroupType type, RoleId roleId);
}
