package ru.yandex.mail.cerberus.dao.group;

import lombok.val;
import one.util.streamex.StreamEx;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.cerberus.GroupKey;
import ru.yandex.mail.cerberus.GroupType;
import ru.yandex.mail.cerberus.RoleId;
import ru.yandex.mail.micronaut.common.Page;
import ru.yandex.mail.micronaut.common.Pageable;
import ru.yandex.mail.cerberus.asyncdb.Condition;
import ru.yandex.mail.cerberus.asyncdb.RoCrudRepository;
import ru.yandex.mail.cerberus.asyncdb.annotations.CompositeId;
import ru.yandex.mail.cerberus.asyncdb.annotations.ConfigureCrudRepository;

import java.util.List;
import java.util.Optional;

@CompositeId
@ConfigureCrudRepository(table = "cerberus.groups")
public interface RoGroupRepository extends RoCrudRepository<GroupKey, GroupEntity> {
    default Page<GroupKey, GroupEntity> findPage(Pageable<GroupKey> pageable) {
        return findPage(pageable, entity -> new GroupKey(entity.getId(), entity.getType()));
    }

    default Page<GroupId, GroupEntity> findPageByType(Pageable<GroupId> pageable, GroupType type) {
        val condition = Condition.of("type = :type").bind("type", type);
        val page = findPage(pageable.map(id -> new GroupKey(id, type)),
            entity -> new GroupKey(entity.getId(), entity.getType()),
            condition);
        return page.mapNextPageId(GroupKey::getId);
    }

    @SqlQuery("SELECT <entityColumnsList> FROM <table>\n"
            + "WHERE type = :type AND id IN (<ids>)")
    List<GroupEntity> findByType(GroupType type, @BindList Iterable<GroupId> ids);

    @SqlQuery("SELECT id FROM <table>\n"
            + "WHERE type = :type AND name = :name\n"
            + "LIMIT :limit")
    List<GroupId> findGroupIds(GroupType type, String name, int limit);

    default Optional<GroupId> findFirstGroupId(GroupType type, String name) {
        return StreamEx.of(findGroupIds(type, name, 1)).findFirst();
    }

    @SqlQuery("SELECT role_id FROM cerberus.group_roles\n"
            + "WHERE group_type = :type AND group_id = :id")
    List<RoleId> findGroupRoleIds(GroupType type, GroupId id);
}
