package ru.yandex.mail.cerberus.dao.location;

import lombok.Value;
import ru.yandex.mail.cerberus.LocationId;
import ru.yandex.mail.cerberus.LocationKey;
import ru.yandex.mail.cerberus.LocationType;
import ru.yandex.mail.cerberus.asyncdb.annotations.Id;
import ru.yandex.mail.cerberus.asyncdb.annotations.JsonB;
import ru.yandex.mail.cerberus.asyncdb.annotations.Serial;

import java.util.Optional;

@Value
public class LocationEntity {
    @Id @Serial LocationId id;
    @Id LocationType type;
    String name;
    @JsonB Optional<String> info;

    public LocationKey extractKey() {
        return new LocationKey(id, type);
    }
}
