package ru.yandex.mail.cerberus.dao.location;

import lombok.val;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import ru.yandex.mail.cerberus.LocationId;
import ru.yandex.mail.cerberus.LocationKey;
import ru.yandex.mail.cerberus.LocationType;
import ru.yandex.mail.micronaut.common.Page;
import ru.yandex.mail.micronaut.common.Pageable;
import ru.yandex.mail.cerberus.asyncdb.Condition;
import ru.yandex.mail.cerberus.asyncdb.RoCrudRepository;
import ru.yandex.mail.cerberus.asyncdb.annotations.CompositeId;
import ru.yandex.mail.cerberus.asyncdb.annotations.ConfigureCrudRepository;

import java.util.List;

@CompositeId
@ConfigureCrudRepository(table = "cerberus.locations")
public interface RoLocationRepository extends RoCrudRepository<LocationKey, LocationEntity> {
    default Page<LocationKey, LocationEntity> findPage(Pageable<LocationKey> pageable) {
        return findPage(pageable, entity -> new LocationKey(entity.getId(), entity.getType()));
    }

    default Page<LocationId, LocationEntity> findPageByType(Pageable<LocationId> pageable, LocationType type) {
        val condition = Condition.of("type = :type").bind("type", type);
        val genericPageable = pageable.map(id -> new LocationKey(id, type));
        val page = findPage(genericPageable, entity -> new LocationKey(entity.getId(), entity.getType()), condition);
        return page.mapNextPageId(LocationKey::getId);
    }

    @SqlQuery("SELECT <entityColumnsList> FROM <table>\n"
            + "WHERE type = :type AND id IN (<ids>)")
    List<LocationEntity> findByType(LocationType type, @BindList Iterable<LocationId> ids);
}
