package ru.yandex.mail.cerberus.dao.resource;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import org.jdbi.v3.core.mapper.Nested;
import ru.yandex.mail.cerberus.LocationKey;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceKey;
import ru.yandex.mail.cerberus.ResourceTypeName;
import ru.yandex.mail.cerberus.asyncdb.annotations.Id;
import ru.yandex.mail.cerberus.asyncdb.annotations.JsonB;
import ru.yandex.mail.cerberus.asyncdb.annotations.Serial;

import javax.annotation.Nullable;
import java.util.Optional;

@Value
@AllArgsConstructor
@Builder(toBuilder = true)
public class ResourceEntity {
    @Id @Serial ResourceId id;
    @Id ResourceTypeName type;
    @Nested("location") @Nullable LocationKey location;
    String name;
    boolean active;
    @JsonB Optional<String> info;

    public ResourceKey extractKey() {
        return new ResourceKey(id, type);
    }
}
