package ru.yandex.mail.cerberus.dao.resource;

import lombok.val;
import one.util.streamex.StreamEx;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceKey;
import ru.yandex.mail.cerberus.ResourceTypeName;
import ru.yandex.mail.cerberus.asyncdb.CrudRepository;
import ru.yandex.mail.cerberus.asyncdb.annotations.CompositeId;
import ru.yandex.mail.cerberus.asyncdb.annotations.ConfigureCrudRepository;

import java.util.Collection;
import java.util.List;

@CompositeId
@ConfigureCrudRepository(table = "cerberus.resource")
public interface ResourceRepository extends RoResourceRepository, CrudRepository<ResourceKey, ResourceEntity> {
    default boolean delete(ResourceId id, ResourceTypeName type) {
        return delete(new ResourceKey(id, type));
    }

    default List<ResourceKey> deleteAll(ResourceTypeName type, Collection<ResourceId> ids) {
        val keys = StreamEx.of(ids)
            .map(id -> new ResourceKey(id, type))
            .toImmutableList();
        return deleteAll(keys);
    }
}
