package ru.yandex.mail.cerberus.dao.resource;

import lombok.val;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import ru.yandex.mail.micronaut.common.Page;
import ru.yandex.mail.micronaut.common.Pageable;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceKey;
import ru.yandex.mail.cerberus.ResourceTypeName;
import ru.yandex.mail.cerberus.asyncdb.Condition;
import ru.yandex.mail.cerberus.asyncdb.RoCrudRepository;
import ru.yandex.mail.cerberus.asyncdb.annotations.CompositeId;
import ru.yandex.mail.cerberus.asyncdb.annotations.ConfigureCrudRepository;

import java.util.Collection;
import java.util.List;

@CompositeId
@ConfigureCrudRepository(table = "cerberus.resource")
public interface RoResourceRepository extends RoCrudRepository<ResourceKey, ResourceEntity> {
    default Page<ResourceKey, ResourceEntity> findPage(Pageable<ResourceKey> page) {
        return findPage(page, entity -> new ResourceKey(entity.getId(), entity.getType()));
    }

    default Page<ResourceId, ResourceEntity> findPageByType(Pageable<ResourceId> pageable, ResourceTypeName type) {
        val condition = Condition.of("type = :type").bind("type", type);
        final var genericPageable = pageable.map(id -> new ResourceKey(id, type));
        val page = findPage(genericPageable, entity -> new ResourceKey(entity.getId(), entity.getType()), condition);
        return page.mapNextPageId(ResourceKey::getId);
    }

    @SqlQuery("SELECT <entityColumnsList> FROM <table>\n"
            + "WHERE type = :type AND id IN (<ids>)")
    List<ResourceEntity> findById(ResourceTypeName type, @BindList Collection<ResourceId> ids);
}
