package ru.yandex.mail.cerberus.dao.resource_type;

import lombok.Value;
import org.jdbi.v3.core.mapper.Nested;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import ru.yandex.mail.cerberus.ResourceTypeName;
import ru.yandex.mail.cerberus.asyncdb.CrudRepository;
import ru.yandex.mail.cerberus.asyncdb.annotations.ConfigureCrudRepository;

@ConfigureCrudRepository(table = "cerberus.resource_type")
@RegisterConstructorMapper(ResourceTypeRepository.InsertResult.class)
public interface ResourceTypeRepository extends RoResourceTypeRepository, CrudRepository<ResourceTypeName, ResourceTypeEntity> {
    @Value
    class InsertResult {
        @Nested ResourceTypeEntity entity;
        boolean inserted;
    }

    @SqlQuery("INSERT INTO <table> (name, description, action_set) "
            + "VALUES (:name, :description, :actionSet) "
            + "ON CONFLICT (name) DO UPDATE SET name = EXCLUDED.name "
            + "RETURNING *, (xmax = 0) as inserted")
    InsertResult createIfNotExist(@BindBean ResourceTypeEntity entity);
}
