package ru.yandex.mail.cerberus.dao.role;

import ru.yandex.mail.micronaut.common.Page;
import ru.yandex.mail.micronaut.common.Pageable;
import ru.yandex.mail.cerberus.RoleId;
import ru.yandex.mail.cerberus.asyncdb.RoCrudRepository;
import ru.yandex.mail.cerberus.asyncdb.annotations.ConfigureCrudRepository;

@ConfigureCrudRepository(table = "cerberus.roles")
public interface RoRoleRepository extends RoCrudRepository<RoleId, RoleEntity> {
    default Page<RoleId, RoleEntity> findPage(Pageable<RoleId> pageable) {
        return findPage(pageable, RoleEntity::getId);
    }
}
