package ru.yandex.mail.cerberus.dao.role;

import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import ru.yandex.mail.cerberus.RoleId;
import ru.yandex.mail.cerberus.asyncdb.CrudRepository;
import ru.yandex.mail.cerberus.asyncdb.annotations.ConfigureCrudRepository;

import java.util.Optional;

@ConfigureCrudRepository(table = "cerberus.roles")
public interface RoleRepository extends RoRoleRepository, CrudRepository<RoleId, RoleEntity> {
    @GetGeneratedKeys
    @SqlUpdate("DELETE FROM <table>\n"
             + "WHERE name = :name\n"
             + "RETURNING <id>")
    Optional<RoleId> deleteByName(String name);
}
