package ru.yandex.mail.cerberus.dao.tx;

import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import reactor.core.publisher.Mono;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public interface TxManager {
    void run(Runnable runnable, Isolation isolation, Propagation propagation);

    default void run(Runnable runnable) {
        run(runnable, Isolation.DEFAULT, Propagation.REQUIRED);
    }

    CompletableFuture<Void> runAsync(Runnable runnable, Isolation isolation, Propagation propagation);

    default CompletableFuture<Void> runAsync(Runnable runnable) {
        return runAsync(runnable, Isolation.DEFAULT, Propagation.REQUIRED);
    }

    default Mono<Void> runReactive(Runnable runnable, Isolation isolation, Propagation propagation) {
        return Mono.fromFuture(runAsync(runnable, isolation, propagation));
    }

    default Mono<Void> runReactive(Runnable runnable) {
        return Mono.fromFuture(runAsync(runnable));
    }

    <T> T execute(Supplier<T> call, Isolation isolation, Propagation propagation);

    default <T> T execute(Supplier<T> call) {
        return execute(call, Isolation.DEFAULT, Propagation.REQUIRED);
    }

    <T> CompletableFuture<T> executeAsync(Supplier<T> call, Isolation isolation, Propagation propagation);

    default <T> CompletableFuture<T> executeAsync(Supplier<T> call) {
        return executeAsync(call, Isolation.DEFAULT, Propagation.REQUIRED);
    }

    default <T> Mono<T> executeReactive(Supplier<T> call, Isolation isolation, Propagation propagation) {
        return Mono.fromFuture(executeAsync(call, isolation, propagation));
    }

    default <T> Mono<T> executeReactive(Supplier<T> call) {
        return Mono.fromFuture(executeAsync(call));
    }
}
