package ru.yandex.mail.cerberus.dao.tx;

import ru.yandex.mail.cerberus.ReadTarget;
import ru.yandex.mail.micronaut.common.qualifier.Master;
import ru.yandex.mail.micronaut.common.qualifier.Slave;

import javax.inject.Inject;
import javax.inject.Singleton;
import java.util.Optional;

@Singleton
public class TxManagerGroup {
    private final TxManager txManager;
    private final TxManager roTxManager;

    @Inject
    public TxManagerGroup(@Master TxManager txManager, @Slave Optional<TxManager> roTxManager) {
        this.txManager = txManager;
        this.roTxManager = roTxManager.orElse(txManager);
    }

    public TxManager getReading(ReadTarget readTarget) {
        return readTarget == ReadTarget.SLAVE ? roTxManager : txManager;
    }

    public TxManager getReading() {
        return roTxManager;
    }

    public TxManager getWriting() {
        return txManager;
    }
}
