### Задачи сервиса
1. Синк пользователей и департаментов из источников*.
2. Синк переговорок из источников (будущий сервис переговорок может быть одним из источником, но пока стафф). Все новые переговорки заводятся как закрытые.
3. Предоставлять возможность пользователям с определенными права выполнять настройку доступа к переговорокам для: других пользователей, подразделений со стафф, проектам из ABC.
4. Предоставлять возможность расшаривать слои между пользователями.
5. Предоставлять возможность проверить уровень доступа пользователя ко встречам и слоям.
6. Интеграция с IDM.

**Под источником подразумевается любое хранилище, которое может предоставить необходимую информацию об объектах своей предметной области. Т.к. на горизонте маячит коннект, то стоит заранее предусмотреть то, что переговорки и пользователи могут приезжать не только со стаффа*.

### Таблицы в БД
* Пользователи - информация о пользователях
* Департаменты - информация о департаментах
* Переговорки - базовая информация о переговорках
* Доступ к слоям - список пользователей/групп к слою с определенной настройкой доступа
* Доступ к переговоркам - список прав доступа пользователей/департаментов к конкретным переговоркам с определенной настройкой доступа
* Changelog - партицированая по дням таблица со списком изменений состава доступов, пользователей и переговорок.
* Таски - список тасков для выполнения воркерами.

### Роли пользователей
Глобальные:
* __Root__ - полный доступ ко всему
* __Room admin__ - доступ к редактированию переговорок во всех встречах + полный доступ к использованию всех переговорок

Локальные по переговоркам:
* __User__ - пользователь переговорки, имеет право на бронь
* __Admin__ - админ переговорки, имеет доступ на редактирование переговорки во всех встречах + возможность ее бронировать

Локальные по слоям:
* __Viewer__ - доступ на просмотр всех событий слоя (в том числе закрытых)
* __Creator__ - __Viewer__ + доступ на создание новых встреч
* __Editor__ - полный доступ на просмотр и редактирование/создание встреч

### Уровни доступа ко встрече
* __ViewAll__ - просмотр всей информации о встрече
* __View__ - частичный просмотр информации о встрече (доступные элементы выдаются отдельным списком)
* __EditAll__ - просмотр и редактирование всей информации о встрече
* __Edit__ - частичный просмотр и редактирование информации о встрече (доступные элементы выдаются отдельным списком)

### Worker
Сервис, который производит синхронизацию пользователей и переговорок с источниками. Планирует таски в [CMB](https://github.yandex-team.ru/mail/callmeback), при получении вызова от [CMB](https://github.yandex-team.ru/mail/callmeback) кладет таск в таблицу. Периодически poll'ит таблицу тасков, пытаясь взять лок на запись таска, в случае успеха - выполняет таск и удаляет запись.
Основные таски: обновить список пользователей/департаментов/переговорок, сбросить changelog в YT.

### API (Back)
Предоставляет api (GraphQL???) проверки и менеджмента доступов. Предполагаются следующие ручки:
* __users__ - получить/выбрать список пользователей с необходимой информацией о них
* __manage_layers__ - CRUD для шаринга слоев.
* __manage_roles__ - CRUD для изменения ролей пользователей/департаментов.
* __event_grants__ - получить уровень доступа пользователя ко встрече. Аргументы: uid, слой встречи, флаг закрытости, список переговорок встречи.
* __layer_grants__ - получить уровень доступа к слою (используется для проверки возможности создать встречу в слое)

### Кеширование
Т.к. логика сервиса предполагает редкие записи в БД, то бэкенды будут хранить все данные в локальном in memory кеше с вытеснением на диск и последующей синхронизацией из БД. Это позволит минимизировать число запросов в БД и ускорить время ответа сервиса. Время ответа довольно критичный критерий, т.к. проверка доступа - довольно распространенная операция в логике бэка календаря.
Для реализации синхронизации есть два варианта:
1. Бэкенд хранит номер последней синхронизированной ревизии и последовательно вычитывает из changelog'а новые изменения, применяя их к локальной копии.
2. Бэкенд использует механизм репликации, который доступен в JDBC драйвере Postgres'а.

Чтение предполагается осуществлять с синхронной реплики + фолбэк на мастер.

Таким образом, старт бэкендов воркеров и api разделяется на холодный и горячий:
* Холодный означает, что бэкенд не имеет никакой информации из базы и он должен загрузить все данные в кеш после чего начать процесс постоянной синхронизации.
* Горячий означает, что у бэкенда уже есть некоторое состояние базы и требуется лишь досинхронизировать эти изменения.