#!/bin/bash

if [ -z $ENVIRONMENT_TYPE ];then
    export ENVIRONMENT_TYPE=$QLOUD_ENVIRONMENT
fi

if [ -z $APPLICATION_DOMAIN ];then
    export APPLICATION_DOMAIN=$(echo $QLOUD_APPLICATION | grep -Po '(?<=cerberus-).+')
fi

if [ -z $APPLICATION_NAME ];then
    export APPLICATION_NAME=$QLOUD_COMPONENT
fi

if [ -z $ACTIVE_PROCESSOR_COUNT ];then
    export ACTIVE_PROCESSORS_COUNT=${QLOUD_CPU_LIMIT/.*}
fi

if [ -z $MEMORY_LIMIT ];then
    export MEMORY_LIMIT=$QLOUD_MEMORY_LIMIT
fi

export ENVIRONMENTS=${APPLICATION_DOMAIN}_${ENVIRONMENT_TYPE},$APPLICATION_DOMAIN,$ENVIRONMENT_TYPE
echo $ENVIRONMENT_TYPE > /etc/yandex/environment.type

. /usr/lib/qloud-mail-common.sh
check_ephemeral && (
  qloud_link /var/log/cerberus
  qloud_link /var/log/nginx
  qloud_link /var/heapdumps
)

mkdir -p /var/heapdumps/
mkdir -p /var/log/cerberus/
mkdir -p /etc/nginx/sites-enabled/

# just to avoid library version tracking
for f in /usr/lib/yandex/cerberus/lib/ea-async-*.jar; do
  ln -svf "$f" /usr/lib/yandex/cerberus/lib/ea-async.jar
done

ln -svf /etc/yandex/cerberus/${APPLICATION_NAME}-${ENVIRONMENT_TYPE}.jvmargs /etc/yandex/cerberus/jvmargs
ln -svf /etc/supervisor/$APPLICATION_NAME.conf /etc/supervisor/conf.d/
ln -svf /etc/nginx/sites-available/$APPLICATION_NAME.conf /etc/nginx/sites-enabled/

if [ $ENVIRONMENT_TYPE == 'production' ];then
    ln -svf /etc/supervisor/conf-available/push-client.conf                                /etc/supervisor/conf.d/
    ln -svf /etc/push-client/conf-available/${APPLICATION_NAME}-${APPLICATION_DOMAIN}.yaml /etc/push-client/
fi

exec "$@"
