#!/bin/bash

function mergeClasspath() {
    cat $@ | grep -v lombok | sort | uniq | sed -e 's/^/\/usr\/lib\/yandex\/cerberus\/lib\//' | paste -d: -s
}

if [ $APPLICATION_NAME = "cerberus" ]; then
    CLASSPATH=$(mergeClasspath /etc/yandex/cerberus/cerberus.classpath)
    MAIN_CLASS=ru.yandex.mail.cerberus.Main
elif [ $APPLICATION_NAME = "worker" ]; then
    MAIN_CLASS=ru.yandex.mail.cerberus.worker.Main
    if [ $APPLICATION_DOMAIN = "yt" ]; then
        CLASSPATH=$(mergeClasspath /etc/yandex/cerberus/cerberus_worker.classpath\
                                   /etc/yandex/cerberus/cerberus_worker_tasks.classpath\
                                   /etc/yandex/cerberus/cerberus_worker_yt_tasks.classpath)
    else
        CLASSPATH=$(mergeClasspath /etc/yandex/cerberus/cerberus_worker.classpath\
                                   /etc/yandex/cerberus/cerberus_worker_tasks.classpath)
    fi
fi

exec java -showversion\
    @/etc/yandex/cerberus/jvmargs\
    -server\
    -XX:+HeapDumpOnOutOfMemoryError\
    -XX:HeapDumpPath=/var/heapdumps\
    -Dfile.encoding=UTF-8\
    -Djava.net.preferIPv6Addresses=true\
    -XX:MaxRAM=$MEMORY_LIMIT\
    -Xdebug\
    -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=*:55535\
    -XX:ActiveProcessorCount=$((ACTIVE_PROCESSORS_COUNT*2))\
    -Dmicronaut.env.deduction=false\
    -Dmicronaut.environments=$ENVIRONMENTS\
    -Dmicronaut.config.files=/etc/yandex/cerberus/secrets.yml\
    -Dlog4j2.contextSelector=org.apache.logging.log4j.core.async.AsyncLoggerContextSelector\
    -Dlog4j2.garbagefreeThreadContextMap=true\
    -Dlog4j2.formatMsgAsync=true\
    -Dlog4j2.disableJmx=true\
    -Dlog4j2.asyncLoggerRingBufferSize=$((1024*1024))\
    -javaagent:/usr/lib/yandex/cerberus/lib/ea-async.jar\
    -Dcom.sun.management.jmxremote\
    -Dcom.sun.management.jmxremote.port=55555\
    -Dcom.sun.management.jmxremote.ssl=false\
    -Dcom.sun.management.jmxremote.authenticate=false\
    -Dcom.sun.management.jmxremote.local.only=true\
    -classpath $CLASSPATH:/etc/yandex/cerberus/$APPLICATION_NAME/\
    $MAIN_CLASS
