IF (NOT UBERJAR_BUILD)
    GENERATE_SCRIPT(
        TEMPLATE ${ARCADIA_ROOT}/mail/cerberus/classpath.tmpl
        OUT ${BINDIR}/cerberus.classpath
    )
ENDIF()

IF (UBERJAR_BUILD)
    UBERJAR()
    UBERJAR_SERVICES_RESOURCE_TRANSFORMER()
ENDIF()

NO_LINT()
CHECK_JAVA_DEPS(yes)

JAVAC_FLAGS(
    -parameters
    -Xlint:unchecked
)

JVM_ARGS(
    -javaagent:${EA_ASYNC_AGENT_PATH}
)

JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/mail/cerberus/service/src/main/java **/*)
JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/mail/cerberus/service/src/main/resources **/*)

INCLUDE(${ARCADIA_ROOT}/mail/micronaut/dependency_versions.inc)
INCLUDE(${ARCADIA_ROOT}/mail/micronaut/micronaut_http_server.inc)
INCLUDE(${ARCADIA_ROOT}/mail/micronaut/micronaut_http_client.inc)
INCLUDE(${ARCADIA_ROOT}/mail/cerberus/micronaut_jdbc.inc)

PEERDIR(
    mail/cerberus/core
    mail/micronaut/tvm
    mail/micronaut/micrometer
    mail/micronaut/http_logger
    mail/micronaut/http_logger/http_logger_log4j2

    contrib/java/org/apache/logging/log4j/log4j-1.2-api
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-yaml
    contrib/java/io/micronaut/micronaut-management
    contrib/java/com/lmax/disruptor
    contrib/java/io/netty/netty-transport-native-epoll-linux-x86_64
)

EXCLUDE(
    contrib/java/log4j/log4j
)

ANNOTATION_PROCESSOR(
    lombok.launch.AnnotationProcessorHider$AnnotationProcessor
    io.micronaut.annotation.processing.TypeElementVisitorProcessor
    io.micronaut.annotation.processing.PackageConfigurationInjectProcessor
    io.micronaut.annotation.processing.BeanDefinitionInjectProcessor
)
