package ru.yandex.mail.cerberus.controller;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Error;
import io.micronaut.http.annotation.Produces;
import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.client.dto.ErrorResult;
import ru.yandex.mail.cerberus.error.ServerErrorException;

@Controller
public class ErrorController {
    private static final HttpResponse<ErrorResult> UNEXPECTED_RESULT_RESPONSE =
        HttpResponse.serverError(new ErrorResult("Unexpected exception occurred", ErrorCode.INTERNAL_ERROR));

    @Error(global = true)
    @Produces(MediaType.APPLICATION_JSON)
    public HttpResponse<ErrorResult> handle(HttpRequest request, Throwable e) {
        if (e instanceof ServerErrorException) {
            return ((ServerErrorException) e).getResponse();
        } else {
            return UNEXPECTED_RESULT_RESPONSE;
        }
    }
}
