package ru.yandex.mail.cerberus.error;

import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseProvider;
import ru.yandex.mail.cerberus.client.dto.ErrorResult;

public class ServerErrorException extends RuntimeException implements HttpResponseProvider {
    private final HttpResponse<ErrorResult> response;

    public ServerErrorException(Throwable cause, HttpResponse<ErrorResult> response) {
        super(cause);
        this.response = response;
    }

    @Override
    public HttpResponse<ErrorResult> getResponse() {
        return response;
    }
}
