package ru.yandex.mail.cerberus;

import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import ru.yandex.mail.micronaut.common.value.LongValueType;

import java.util.Optional;
import java.util.function.LongFunction;

@AllArgsConstructor(access = AccessLevel.PROTECTED)
abstract class BaseLongValueConverter<T extends LongValueType> implements TypeConverter<String, T> {
    private final LongFunction<T> constructor;

    @Override
    public Optional<T> convert(String object, Class<T> targetType, ConversionContext context) {
        try {
            return Optional.of(constructor.apply(Long.parseLong(object)));
        } catch (NumberFormatException e) {
            context.reject(e);
            return Optional.empty();
        }
    }
}
