package ru.yandex.mail.cerberus;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.micronaut.common.value.LongValueType;

import javax.inject.Singleton;

@Singleton
class GrantIdConverter extends BaseLongValueConverter<GrantId> {
    public GrantIdConverter() {
        super(GrantId::new);
    }
}

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class GrantId implements LongValueType {
    long value;

    @Override
    public String toString() {
        return Long.toString(value);
    }
}
