package ru.yandex.mail.cerberus;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.micronaut.common.value.ValueType;

import javax.inject.Singleton;
import javax.validation.constraints.NotBlank;
import java.util.Optional;

@Singleton
class GroupTypeConverter implements TypeConverter<String, GroupType> {
    @Override
    public Optional<GroupType> convert(String object, Class<GroupType> targetType, ConversionContext context) {
        return Optional.of(new GroupType(object));
    }
}

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class GroupType implements ValueType<String> {
    public static final GroupType INTERNAL = new GroupType("internal");

    @NotBlank String value;

    @Override
    public String toString() {
        return value;
    }
}
