package ru.yandex.mail.cerberus;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.micronaut.common.value.ValueType;

import javax.inject.Singleton;
import java.util.Optional;
import java.util.UUID;

@Singleton
class IdempotencyKeyConverter implements TypeConverter<String, IdempotencyKey> {
    @Override
    public Optional<IdempotencyKey> convert(String object, Class<IdempotencyKey> targetType, ConversionContext context) {
        try {
            return Optional.of(new IdempotencyKey(UUID.fromString(object)));
        } catch (Exception e) {
            context.reject(e);
            return Optional.empty();
        }
    }
}

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class IdempotencyKey implements ValueType<UUID> {
    UUID value;

    @Override
    public String toString() {
        return value.toString();
    }

    public static IdempotencyKey random() {
        return new IdempotencyKey(UUID.randomUUID());
    }
}
