package ru.yandex.mail.cerberus;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.micronaut.common.value.LongValueType;

import javax.inject.Singleton;
import javax.validation.constraints.Positive;

@Singleton
class LocationIdConverter extends BaseLongValueConverter<LocationId> {
    public LocationIdConverter() {
        super(LocationId::new);
    }
}

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class LocationId implements LongValueType {
    @Positive long value;

    @Override
    public String toString() {
        return Long.toString(value);
    }
}
