package ru.yandex.mail.cerberus;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.micronaut.common.value.ValueType;

import javax.inject.Singleton;
import javax.validation.constraints.NotBlank;
import java.util.Optional;

@Singleton
class LocationTypeConverter implements TypeConverter<String, LocationType> {
    @Override
    public Optional<LocationType> convert(String object, Class<LocationType> targetType, ConversionContext context) {
        return Optional.of(new LocationType(object));
    }
}

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class LocationType implements ValueType<String> {
    @NotBlank String value;

    @Override
    public String toString() {
        return value;
    }
}
