package ru.yandex.mail.cerberus;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.micronaut.common.value.ValueType;

import javax.inject.Singleton;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.Optional;

@Singleton
class ResourceTypeNameConverter implements TypeConverter<String, ResourceTypeName> {
    @Override
    public Optional<ResourceTypeName> convert(String object, Class<ResourceTypeName> targetType, ConversionContext context) {
        return Optional.of(new ResourceTypeName(object));
    }
}

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class ResourceTypeName implements ValueType<String> {
    public static final ResourceTypeName LAYER = new ResourceTypeName("layer");

    @NotBlank @Size(max = 20) String value;

    @Override
    public String toString() {
        return value;
    }
}
