package ru.yandex.mail.cerberus;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.micronaut.common.value.ValueType;

import javax.inject.Singleton;
import javax.validation.constraints.NotBlank;
import java.util.Optional;

@Singleton
class RoleNameConverter implements TypeConverter<String, RoleName> {
    @Override
    public Optional<RoleName> convert(String object, Class<RoleName> targetType, ConversionContext context) {
        return Optional.of(new RoleName(object));
    }
}

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class RoleName implements ValueType<String> {
    @NotBlank String value;

    @Override
    public String toString() {
        return value;
    }
}
