package ru.yandex.mail.cerberus;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.micronaut.common.value.ValueType;

import javax.inject.Singleton;
import java.util.Optional;

@Singleton
class TaskTypeConverter implements TypeConverter<String, TaskType> {
    @Override
    public Optional<TaskType> convert(String object, Class<TaskType> targetType, ConversionContext context) {
        return Optional.of(new TaskType(object));
    }
}

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class TaskType implements ValueType<String> {
    String value;

    @Override
    public String toString() {
        return value;
    }
}
