package ru.yandex.mail.cerberus;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;
import ru.yandex.mail.micronaut.common.value.LongValueType;

import javax.inject.Singleton;
import javax.validation.constraints.PositiveOrZero;

@Singleton
class UidConverter extends BaseLongValueConverter<Uid> {
    public UidConverter() {
        super(Uid::new);
    }
}

@Value
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class Uid implements LongValueType {
    public static final Uid DEFAULT_USER = new Uid(0L);

    @PositiveOrZero long value;

    @Override
    public String toString() {
        return Long.toString(value);
    }
}
