package ru.yandex.mail.cerberus.exception;

import one.util.streamex.StreamEx;

import java.util.Collection;

public abstract class EntityAlreadyExistsException extends CerberusException {
    protected EntityAlreadyExistsException(String message, Throwable cause) {
        super(message, cause);
    }

    protected EntityAlreadyExistsException(String message) {
        super(message);
    }

    protected <ID> EntityAlreadyExistsException(String entityName, ID id) {
        this(entityName + " = [" + id + "] already exists");
    }

    protected <ID> EntityAlreadyExistsException(String entityName, Collection<ID> ids) {
        this(entityName + " = [" + StreamEx.of(ids).joining(", ") + "] already exists");
    }
}
