package ru.yandex.mail.cerberus.exception;

import one.util.streamex.StreamEx;

import java.util.Collection;

public abstract class EntityNotFoundException extends CerberusException {
    protected EntityNotFoundException(String message, Throwable cause) {
        super(message, cause);
    }

    protected EntityNotFoundException(String message) {
        super(message);
    }

    protected <ID> EntityNotFoundException(String entityName, ID id) {
        this(entityName + " = [" + id + "] not found");
    }

    protected <ID> EntityNotFoundException(String entityName, Collection<ID> ids) {
        this(entityName + " = [" + StreamEx.of(ids).joining(", ") + "] not found");
    }
}
