package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.ResourceId;
import ru.yandex.mail.cerberus.ResourceTypeName;

import java.util.Optional;

public class GrantNotFoundException extends EntityNotFoundException {
    private static String toString(Optional<ResourceId> resourceId) {
        return resourceId.map(ResourceId::toString).orElse("");
    }

    public GrantNotFoundException(ResourceTypeName resourceType, Optional<ResourceId> resourceId) {
        super("Grant for resource id=" + toString(resourceId) + ", type=" + resourceType + " not found");
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.GRANT_NOT_FOUND;
    }
}
