package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.GroupKey;

import java.util.Collection;

public class GroupAlreadyExistsException extends EntityAlreadyExistsException {
    public GroupAlreadyExistsException(String message) {
        super(message);
    }

    public GroupAlreadyExistsException(GroupKey key) {
        super("Group", key);
    }

    public GroupAlreadyExistsException(Collection<GroupKey> keys) {
        super("Groups", keys);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.GROUP_ALREADY_EXISTS;
    }
}
