package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.GroupKey;

import java.util.Collection;

public class GroupNotFoundException extends EntityNotFoundException {
    public GroupNotFoundException(String message) {
        super(message);
    }

    public GroupNotFoundException(GroupKey key) {
        super("Group", key);
    }

    public GroupNotFoundException(Collection<GroupKey> keys) {
        super("Groups", keys);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.GROUP_NOT_FOUND;
    }
}
