package ru.yandex.mail.cerberus.exception;

import ru.yandex.mail.cerberus.ErrorCode;
import ru.yandex.mail.cerberus.LocationKey;

import java.util.Collection;

public class LocationAlreadyExistsException extends EntityAlreadyExistsException {
    public LocationAlreadyExistsException(String message) {
        super(message);
    }

    public LocationAlreadyExistsException(LocationKey key) {
        super("Location", key);
    }

    public LocationAlreadyExistsException(Collection<LocationKey> keys) {
        super("Locations", keys);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.LOCATION_ALREADY_EXISTS;
    }
}
